using System;
using System.Collections;
using J2EE.Naming;
using J2EE.Rmi;
using examples;

class Client {

  static void Main(string[] args) {

    try {
      // initialize orb
      CORBA.ORB orb = CORBA.ORB.Init(args);

      // register override value factories
      orb.RegisterValueFactory(new examples.ArrayListMashaledAsHashSetValueFactory());
      orb.RegisterValueFactory(new examples.ArrayListMashaledAsVectorValueFactory());

      // home look up and object creation
      Context root = new InitialContext();
      object obj = root.Lookup("examples/onetomany");
      One2ManyHome home = (One2ManyHome) 
        PortableRemoteObject.Narrow(obj, typeof(One2ManyHome));
      One2Many server = home.Create();

      // do tests
      Hashtable hashtable = new Hashtable();
      ArrayList asVector = new examples.ArrayListMashaledAsVector();
      ArrayList asHashSet = new examples.ArrayListMashaledAsHashSet();
      Fill(asVector);
      Fill(asHashSet);
      hashtable.Add(asVector, asVector);
      hashtable.Add(asHashSet, asHashSet);
      // server expects a java.util.Vector and a java.util.HashSet in the hashtable
      server.Indirections(hashtable);
      
      Console.WriteLine("All tests passed.");
    }
    catch(Exception e) {
      Console.WriteLine("Caught an unexpected exception: ");
      Console.WriteLine(e);
    }
    Console.ReadLine();
  }

  private static object[] LIST_DATA = { "This", "is", "an", "override", "example" };

  private static ArrayList Fill(ArrayList x) {
    foreach(object o in LIST_DATA) {
      x.Add(o);
    }
    return x;

  }

}
